/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

// THeadedBoltDlg.cpp : implementation file
//

#include "stdafx.h"
#include "CClient.h"
#include "THeadedBoltDlg.h"
#include "section.h"
#include "funcheader.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTHeadedBoltDlg dialog


CTHeadedBoltDlg::CTHeadedBoltDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTHeadedBoltDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTHeadedBoltDlg)
	m_boltLength = 0.0;
	m_boltDiameter = 0.0;
	//}}AFX_DATA_INIT
}


void CTHeadedBoltDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTHeadedBoltDlg)
	DDX_Text(pDX, IDC_THBEDIT1, m_boltLength);
	DDX_Text(pDX, IDC_THBEDIT2, m_boltDiameter);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTHeadedBoltDlg, CDialog)
	//{{AFX_MSG_MAP(CTHeadedBoltDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTHeadedBoltDlg message handlers

void CTHeadedBoltDlg::OnOK() 
{
	HRESULT status = CONV_SUCCESS;
	UpdateData(TRUE);

	if(m_boltLength >0 && m_boltDiameter > 0 ) {
		
		status = CreateTeeHeadedBolt(m_boltLength/1000, m_boltDiameter/1000);
		if(status != 0){
			AfxMessageBox("CreateTeeHeadedBolt failed");
		}
	}
	else
		AfxMessageBox("Invalid Input");
	
	CDialog::OnOK();
}
